#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAXN 100001

// ???????? ??????????
int N, M, Q, P;
int A[MAXN];
int susedi[MAXN][MAXN];
int stepen[MAXN];

// ???????? ?? ???????? ????? ? ????
void dodaj_granu(int u, int v) {
    susedi[u][stepen[u]++] = v;
    susedi[v][stepen[v]++] = u;
}

// ?????????? ?? ????????? (??????? ?? ?? ???????? ????????)
int uporedi(const void *a, const void *b) {
    return (*(int *)a - *(int *)b);
}

// DFS ?? ?????????? ???? ????????? ?? ????
void dfs(int cvor, int cilj, bool poseceni[], int *vrednosti, int *velicina) {
    poseceni[cvor] = true;
    vrednosti[(*velicina)++] = A[cvor - 1]; // ???????? ????????? ????? ? ???

    if (cvor == cilj) return;

    for (int i = 0; i < stepen[cvor]; i++) {
        int sused = susedi[cvor][i];
        if (!poseceni[sused]) {
            dfs(sused, cilj, poseceni, vrednosti, velicina);
            if (poseceni[cilj]) return; // ????????? ??? ?? ??? ?????????
        }
    }
}

// ???????? ?? ???????? ????????
int nadji_medianu(int vrednosti[], int velicina) {
    qsort(vrednosti, velicina, sizeof(int), uporedi); // ????????? ????
    return vrednosti[(velicina - 1) / 2]; // ????????
}

int main() {
    // ?????? ??????
    scanf("%d %d %d %d", &N, &M, &Q, &P);
    for (int i = 0; i < N; i++) {
        scanf("%d", &A[i]);
    }

    for (int i = 0; i < M; i++) {
        int u, v;
        scanf("%d %d", &u, &v);
        dodaj_granu(u, v);
    }

    int odgovor = 0;
    for (int i = 0; i < Q; i++) {
        int a1, b1;
        scanf("%d %d", &a1, &b1);

        // ?????????? `a` ? `b`
        int a = (a1 + odgovor * P - 1) % N + 1;
        int b = (b1 + odgovor * P - 1) % N + 1;

        // DFS ?? ??????????? ???? ????????? ?? ????
        bool poseceni[MAXN] = {0};
        int vrednosti[MAXN];
        int velicina = 0;

        dfs(a, b, poseceni, vrednosti, &velicina);

        // ???????? ????????
        odgovor = nadji_medianu(vrednosti, velicina);
        printf("%d\n", odgovor);
    }

    return 0;
}